/* ------------------------------------------------------------
template for configuring the COM-1232 40 paths parameters 
 delay (0-1023 samples) and 18-bit amplitude scaling coefficient.

 The assembly comprises three ComBlocks:
 COM-5003 LAN/TCP-IP interface
 COM-8001 Arbitrary waveform generator
 COM-1232 Channel emulator

 Operation: 
 Connect the COM-5003 (running option -B) to the LAN. 
 Power up the assembly then run this program. 
 The ComBlock Control Center cannot be used at the same time as 
 both programs use the same IP port on the ComBlock.
--------------------------------------------------------------*/

#include <stdio.h>
#include "winsock2.h"
#define MAX_MESSAGE_LENGTH 273	
short send_command(SOCKET,  char*);


void main() {

	char sendbuf[MAX_MESSAGE_LENGTH];
	long W0, D0;
	long W30, D30;
	unsigned char a;
	long total_bytes_sent = 0;

    // Initialize Winsock.
    WSADATA wsaData;
    int iResult = WSAStartup( MAKEWORD(2,2), &wsaData );
    if ( iResult != NO_ERROR )
        printf("Error at WSAStartup()\n");

    // Create a socket.
    SOCKET m_socket;
    m_socket = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );

    if ( m_socket == INVALID_SOCKET ) {
        printf( "Error at socket(): %ld\n", WSAGetLastError() );
        WSACleanup();
        return;
    }

    // Connect to a server.
    sockaddr_in clientService;

    clientService.sin_family = AF_INET;

// INSERT THE COM-5003 IP ADDRESS BELOW
    clientService.sin_addr.s_addr = inet_addr( "172.16.1.130" );
	// port 1028 is reserved for ComBlock monitoring and control.
    clientService.sin_port = htons(1028);

    if ( connect( m_socket, (SOCKADDR*) &clientService, sizeof(clientService) ) == SOCKET_ERROR) {
        printf( "Failed to connect.\n" );
        WSACleanup();
        return;
    }


	// Assign ComBlock IDs after power up.
	sprintf(sendbuf,"@000SAC001\r\n");
	send_command(m_socket, sendbuf);
		// assign ID 001 to the first module

	sprintf(sendbuf,"@001MFW9\r\n");
	send_command(m_socket, sendbuf);
		// forward messages to all ports

	sprintf(sendbuf,"@000SAC002\r\n");
	send_command(m_socket, sendbuf);
		// assign ID 002 to the first module

	
	sprintf(sendbuf,"@002MFW9\r\n");
	send_command(m_socket, sendbuf);
		// forward messages to all ports

	sprintf(sendbuf,"@000SAC003\r\n");
	send_command(m_socket, sendbuf);
		// assign ID 003 to the first module

	// Set Path amplitude scaling coefficient W0 and delay D0
	W0 = 0x000102;	// 18-bit signed. format 1.17
	D0 = 512;		// Delay 
	a = (unsigned char)(W0 & 0x000000FF);
	sprintf(sendbuf,"@003SRT10%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((W0>>8) & 0x000000FF);
	sprintf(sendbuf,"@003SRT11%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((W0>>16) & 0x00000003);
	a |= (unsigned char)((D0 << 2) * 0x000000FC);
	sprintf(sendbuf,"@003SRT12%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((D0 >> 6) * 0x000000FF);
	sprintf(sendbuf,"@003SRT13%02X\r\n", a);
	send_command(m_socket, sendbuf);


	
	// Set Path amplitude scaling coefficient W30 and delay D30
	W30 = 0x000102;	// 18-bit signed. format 1.17
	D30 = 512;		// Delay 
	a = (unsigned char)(W30 & 0x000000FF);
	sprintf(sendbuf,"@003SRT130%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((W30>>8) & 0x000000FF);
	sprintf(sendbuf,"@003SRT131%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((W30>>16) & 0x00000003);
	a |= (unsigned char)((D30 << 2) * 0x000000FC);
	sprintf(sendbuf,"@003SRT132%02X\r\n", a);
	send_command(m_socket, sendbuf);

	a = (unsigned char)((D30 >> 6) * 0x000000FF);
	sprintf(sendbuf,"@003SRT133%02X\r\n", a);
	send_command(m_socket, sendbuf);


	// close socket
	closesocket(m_socket);

    return;
}

/* send command actually comprises three transactions:
1) sending the original command
2) sending a dummy query
3) waiting for the dummy query's response
This is an indirect way to ensure that the rate at which commands are sent are neither
too slow nor too fast.
*/
short send_command(SOCKET m_socket, char* command){
	short message_length;
	char dummy_query[MAX_MESSAGE_LENGTH];
	char dummy_reply[MAX_MESSAGE_LENGTH];
	short total_bytes_sent = 0;
	short total_bytes_received = 0;

	// send command. Make sure all bytes are sent.
	message_length = strlen(command);
	total_bytes_sent = 0;
	while(total_bytes_sent != message_length){
		total_bytes_sent += send( m_socket, &command[total_bytes_sent], message_length-total_bytes_sent, 0 );
	}
	Sleep(5);	// wait 5 ms before next command


	// dummy command
	sprintf(dummy_query,"@001GRG00\r\n");
	// send command. Make sure all bytes are sent.
	message_length = strlen(dummy_query);
	total_bytes_sent = 0;
	while(total_bytes_sent != message_length){
		total_bytes_sent += send( m_socket, &dummy_query[total_bytes_sent], message_length-total_bytes_sent, 0 );
	}

	// wait for dummy command's response
	// response is 11-byte long.
	total_bytes_received = 0;
	while(total_bytes_received < 11){
		total_bytes_received += recv( m_socket, &dummy_reply[total_bytes_received], 11-total_bytes_received, 0 );
	}
	
	
	return strlen(dummy_reply);
}